\NeedsTeXFormat{LaTeX2e}[1998/12/01] % -*- coding: utf8 -*-
\ProvidesClass{resmath}[2021/12/31 v0.5
  LaTeX class for preparing papers to Researches in Mathematics (2021)]

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Based upon "LaTeX class for preparing papers to IX International Workshop on
% STABILITY AND OSCILLATIONS OF NONLINEAR CONTROL SYSTEMS (2006)",
%
% and kluwer.cls class file for the preparation of articles to be submitted to
% journals or spin-offs of journals published by Kluwer Academic Publishers.
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Options
%
%\newif\ifukr\ukrfalse
%\DeclareOption{ukr}{\ukrtrue}
%\DeclareOption{rus}{\ukrfalse}
\ProcessOptions

\LoadClass[11pt,twoside]{article}

\providecommand{\jourvolume}{$\blacksquare\blacksquare$}
\providecommand{\journumber}{$\blacksquare$}
\providecommand{\jouryear}{$\blacksquare\blacksquare\blacksquare\blacksquare$}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Required packages
%
\RequirePackage{ifthen}
\RequirePackage{amssymb}
\RequirePackage{amsmath}
\RequirePackage{amscd}
\RequirePackage{amsfonts}
\RequirePackage{amsthm}
\RequirePackage{euscript}
\RequirePackage{fancyhdr}
\RequirePackage{graphicx}
\RequirePackage{float}
\RequirePackage{subfigure}
%\RequirePackage{floatflt}
\RequirePackage{wrapfig}
\RequirePackage{multicol}
%\RequirePackage{array}

\newcounter{firstpage}
%\newboolean{isfinal}

\RequirePackage[utf8]{inputenc}
%\RequirePackage[T2A]{fontenc}
\RequirePackage[english,ukrainian]{babel}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Page size
%
\paperwidth=17cm
\hoffset-0.54cm
\textwidth=13cm
\oddsidemargin=1mm
\evensidemargin=0cm
%
\paperheight=26cm
\voffset=-1.04cm
\topmargin=0cm
\headheight=2mm
\headsep=4mm
\textheight=21.2cm
\footskip=8mm

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Page style
%
\pagestyle{fancy}
\lhead{}
\chead{}
\rhead{}
\lfoot{}
\cfoot{}
\rfoot{}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}
\renewcommand{\qedsymbol}{}%убирает квадратик в конце доказательства. Дикое требование издательства.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Localizations
%
\def\rulang{
  \def\udkname{\CYRU\CYRD\CYRK}
  \def\myrefname{
%  \CYRS\cyrp\cyri\cyrs\cyro\cyrk\space \cyrc\cyri\cyrt\cyri\cyrr\cyru\cyre\cyrm\cyrery\cyrh\space \cyri\cyrs\cyrt\cyro\cyrch\cyrn\cyri\cyrk\cyro\cyrv}  %% Список цитируемых источников
  \CYRB\cyri\cyrb\cyrl\cyri\cyro\cyrg\cyrr\cyra\cyrf\cyri\cyrch\cyre\cyrs\cyrk\cyri\cyre\space \cyrs\cyrs\cyrery\cyrl\cyrk\cyri} 
  \def\definitionname{\CYRO\cyrp\cyrr\cyre\cyrd\cyre\cyrl\cyre\cyrn\cyri\cyre}   %%  Определение
  \def\theoremname{
  \CYRT\cyre\cyro\cyrr\cyre\cyrm\cyra}                          %%  Теорема
  \def\lemmaname{\CYRL\cyre\cyrm\cyrm\cyra}                                      %%  Лемма
  \def\corollaryname{\CYRS\cyrl\cyre\cyrd\cyrs\cyrt\cyrv\cyri\cyre}              %%  Следствие
  \def\proofname{\bf\CYRD\cyro\cyrk\cyra\cyrz\cyra\cyrt\cyre\cyrl\cyrsftsn\cyrs\cyrt\cyrv\cyro}        %%  Доказательство
  \def\proposalname{\CYRP\cyrr\cyre\cyrd\cyrl\cyro\cyrzh\cyre\cyrn\cyri\cyre}    %%  Предложение
  \def\propositionname%
  {\CYRU\cyrt\cyrv\cyre\cyrr\cyrzh\cyrd\cyre\cyrn\cyri\cyre}                     %%  Утверждение
  \def\remarkname{\CYRZ\cyra\cyrm\cyre\cyrch\cyra\cyrn\cyri\cyre}                %%  Замечание
  \def\algorithmname{\CYRA\cyrl\cyrg\cyro\cyrr\cyri\cyrt\cyrm}                   %%  Алгоритм
  \def\problemname{\CYRZ\cyra\cyrd\cyra\cyrch\cyra}                              %%  Задача
  \def\examplename{\CYRP\cyrr\cyri\cyrm\cyre\cyrr}                               %%  Пример

  \def\mykeywrdname{\CYRK\cyrl\cyryu\cyrch\cyre\cyrv\cyrery\cyre\space           %% Ключевые слова
                    \cyrs\cyrl\cyro\cyrv\cyra}
  \def\rulangname{\cyrr\cyro\cyrs\cyrii\cyrishrt\cyrs\cyrsftsn\cyrk\cyra}        %% рос_йська
  \def\enlangname{Russian}
}

\def\ukrlang{
\def\udkname{УДК}
\def\myrefname{Бібліографічні посилання}
  \def\figurename{Рис.}
  \def\tablename{Табл.}
  \def\definitionname{Означення}
  \def\theoremname{Теорема}
  \def\lemmaname{Лема}
  \def\corollaryname{Наслідок}
  \def\propositionname{Твердження}
  \def\proposalname{Пропозиція}
  \def\remarkname{Зауваження}
  \def\algorithmname{Алгоритм}
  \def\examplename{Приклад}
  \def\proofname{\bf Доведення}

  \def\mykeywrdname{Ключові слова}

  \def\rulangname{українська}
  \def\enlangname{Ukrainian}
}

\def\spacebeforetheorem{\hspace{6mm}}

\def\englang{
  \def\udkname{UDK}
  \def\myrefname{References}
  \def\figurename{Fig.}
  \def\tablename{Tab.}
  \def\definitionname{Definition}
  \def\theoremname{Theorem}
  \def\lemmaname{Lemma}
  \def\corollaryname{Corollary}
  \def\proofname{\bf Proof}
  \def\proposalname{Proposition}
  \def\propositionname{Proposition}
  \def\remarkname{Remark}
  \def\algorithmname{Algorithm}
  \def\problemname{Problem}
  \def\examplename{Example}

  \def\mykeywrdname{Key words}
  
  \def\rulangname{English}
  \def\enlangname{English}
}

\def\annotnameru{\CYRA\cyrn\cyrn\cyro\cyrt\cyra\cyrc\cyri\cyrya}                %% Аннотация
\def\annotnameua{\CYRA\cyrn\cyro\cyrt\cyra\cyrc\cyrii\cyrya}                    %% Анотація
\def\annotnameen{Abstract}                                                     %%  Abstract

%
% Theorem
%
\theoremstyle{definition}
\newtheorem{definition}{\spacebeforetheorem\definitionname}   %%  Определение
\newtheorem{problem}{\spacebeforetheorem\problemname}         %%  Задача
\newtheorem{proposition}{\spacebeforetheorem\propositionname} %%  Утверждение
\theoremstyle{plain}
\newtheorem{theorem}{\spacebeforetheorem\theoremname}         %%  Теорема
\newtheorem{lemma}{\spacebeforetheorem\lemmaname}             %%  Лемма
\newtheorem{corollary}{\spacebeforetheorem\corollaryname}     %%  Следствие
\newtheorem{proposal}{\spacebeforetheorem\proposalname}       %%  Предложение
\newtheorem{algorithm}{\spacebeforetheorem\algorithmname}     %%  Алгоритм
\theoremstyle{remark}
\newtheorem{remark}{\spacebeforetheorem\remarkname}           %%  Замечание
\newtheorem{example}{\spacebeforetheorem\examplename}         %%  Пример

\theoremstyle{definition}
\newtheorem*{definition*}{\definitionname}   %%  Определение
\newtheorem*{problem*}{\problemname}         %%  Задача
\newtheorem*{proposition*}{\propositionname} %%  Утверждение
\theoremstyle{plain}
\newtheorem*{theorem*}{\theoremname}         %%  Теорема
\newtheorem*{lemma*}{\lemmaname}             %%  Лемма
\newtheorem*{corollary*}{\corollaryname}     %%  Следствие
\newtheorem*{proposal*}{\proposalname}       %%  Предложение
\newtheorem*{algorithm*}{\algorithmname}     %%  Алгоритм
\theoremstyle{remark}
\newtheorem*{remark*}{\remarkname}           %%  Замечание
\newtheorem*{example*}{\examplename}         %%  Пример

%
% choose language
%
%\ifukr
%  \ukrlang
%\else
%  \rulang
%\fi

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% \captioncontent{fltnum}{caption}
%
\def\captioncontent#1#2{{\footnotesize #1. #2}}

%\belowcaptionskip=0pt

\renewcommand{\@makecaption}[2]{
  \vspace{\abovecaptionskip}
  \sbox{\@tempboxa}{\captioncontent{#1}{#2}}
  \ifdim \wd\@tempboxa >\hsize
    \captioncontent{#1}{#2}
  \else
    \global\@minipagefalse
    \hbox to \hsize {\hfil \captioncontent{#1}{#2} \hfil}
  \fi
  \vspace{\belowcaptionskip}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Equation numbering
%
\newif\ifsinglenum\singlenumfalse

\def\theequation{\arabic{section}.\arabic{equation}}
\def\singlenumbering{
  \def\theequation{\arabic{equation}}
  \singlenumtrue}
\def\singlesection{\singlenumbering}

%!%%%%%%%%%%%%%%%%%%%%%%%%%%%
%!%%%% Page number tricks %%%
%!%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newif\iflastpagegiven   \lastpagegivenfalse
\newcommand\firstpage[1]{%
  \gdef\@firstpage{#1}%
  \ifnum\@firstpage>\c@page
    \setcounter{page}{#1}%
  \else \fi
    \xdef\@firstpage{\the\c@page}%
    }
\def\@firstpage{1}
\def\pagenumbering#1{%
    \global\c@page \@ne
    \gdef\thepage{\csname @#1\endcsname \c@page}%
    \gdef\thefirstpage{%
            \csname @#1\endcsname \@firstpage}%
    \gdef\thelastpage{%
            \csname @#1\endcsname \@lastpage}%
    }
\pagenumbering{arabic}
\newcommand\lastpage[1]{\xdef\@lastpage{#1}%
  \global\lastpagegiventrue}
\def\@lastpage{0}
\def\setlastpage{\iflastpagegiven\else
    \edef\@tempa{@lastpage@\the\c@article}%
    \expandafter
    \ifx \csname \@tempa \endcsname \relax
        \gdef\@lastpage{0}%
    \else
        \xdef\@lastpage{\@nameuse{@lastpage@\the\c@article}}%
    \fi
    \fi }
\def\writelastpage{%
    \iflastpagegiven \else
    \immediate\write\@auxout%
    {\string\global\string\@namedef{@lastpage@\the\c@article}{\the\c@page}}%
    \fi
    }
\def\thepagerange{%
  \ifnum\@lastpage =0 {\ \bf PLEASE RUN AGAIN} \else
  \ifnum\@lastpage = \@firstpage \ \thefirstpage\else
  \ \thefirstpage--\thelastpage \fi\fi}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% DOI-related
\def\doiprefix{10.15421} % common prefix for DNU-based journals
\def\doisuffix{$\blacksquare\blacksquare\blacksquare\blacksquare\blacksquare\blacksquare$} % by default
\newcommand{\doisuff}[1]{\def\doisuffix{#1}}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Title page
%

\def\printfirstpagehead{%
{\footnotesize
\noindent
Res. Math.
\textbf{\jourvolume}(\journumber), \jouryear, p.\thepagerange
\hfill
ISSN~(Print)~2664-4991
\\
\texttt{doi:\doiprefix/\doisuffix}
\hfill
ISSN~(Online)~2664-5009
\par}
}

%
% \setupheaders
%
\def\setupheaders{
  \lhead{\footnotesize
         \ifnum\value{page}=\value{firstpage}
			     \textsl{Researches in Mathematics}
           \hfill
           \texttt{https://vestnmath.dnu.dp.ua}
         \else
           \MakeUppercase\theheadings
         \fi}
  \cfoot{\footnotesize
%         \ifnum\value{page}>2 % non-cover pages
           \ifnum\value{page}=\value{firstpage}
             %empty
           \else 
             \thefooters% \thepage
%               \sl ISSN~2664\space 4991\space\space
%               \CYRD\cyrn\cyre\cyrp\cyrr\cyro\cyrp\cyre\cyrt\cyrr\cyro\cyrv\cyrs\cyrk\cyri\cyrishrt\space
%               \cyru\cyrn\cyri\cyrv\cyre\cyrr\cyrs\cyri\cyrt\cyre\cyrt .\space
%               \CYRS\cyre\cyrr\cyri\cyrya : \CYRM\cyra\cyrt\cyre\cyrm\cyra\cyrt\cyri\cyrk\cyra\space
%               \jouryear,\space\cyrv\cyrery\cyrp .\space{\bf\jourvolume}.   
%%               \CYRV\CYRII\CYRS\CYRN\CYRI\CYRK\space\CYRD\CYRN\CYRU, 
%%               \textnumero~({\bf\jourvolume})(\jouryear) 
           \fi
%         \else
%           %empty
%         \fi
}}

\def\printlogo{
  \begin{flushright}
%   \vskip-5mm
   \small\textsf{
      \CYRS\cyre\cyrr\cyrii\cyrya:\space\CYRM\cyra\cyrt\cyre\cyrm\cyra\cyrt\cyri\cyrk\cyra}
%     Серія: Математика   
  \end{flushright}}

%
% \udc{index}
%
\newcommand{\udc}[1]{\def\udcvalue{#1}}

\def\printudc{

  \begin{flushleft}
    \udkname{}
%    \CYRU\CYRD\CYRK
    \space \udcvalue
    \vskip-1mm
  \end{flushleft}}

%
% \setheadings{odd}{even}
%
\newcommand{\setheadings}[2]{
  \gdef\theheadings{
    \ifodd\value{page} 
      #1 % \thepage 
    \else 
      %\thepage 
      #2 
    \fi}}

\newcommand{\setfooters}[2]{
  \gdef\thefooters{\ifodd\value{page} #1 \thepage \else \thepage #2 \fi}}

%
% \setbothheadings{headings}
%
\def\setbothheadings#1{\setheadings{#1}{#1} \setfooters{#1}{#1}}

%
% \topmatter{authors}{shorttitle}
%

\newcommand{\authortitleforheadfootcontent}[2]{
  \setheadings{\hfill \textsl{#2} \hfill}
	      {\hfill \textsl{#1} \hfill}
  \setfooters{\hfill}{\hfill}
  \lfoot{\footnotesize
         \ifnum\value{page}=\value{firstpage}
           {\small \raisebox{1pt}{\copyright} \textsl{\MakeUppercase{#1}, \jouryear}} \hfill \thepage 
         \else
           % empty
         \fi}
  \def\articleauthors{#1}}

\newcommand{\topmatter}[2]{
%  \setheadings{\hfill \textsl{#2} \hfill}
%	      {\hfill \textsl{#1} \hfill}
%  \setfooters{\hfill}
%	      {\hfill}
%  \lfoot{\footnotesize
%        \ifnum\value{page}=\value{firstpage}
%           \small \raisebox{1pt}{\copyright} \sl \MakeUppercase{#1}, \jouryear \hfill \thepage 
%         \else
%           % empty
%         \fi}
%  \def\articleauthors{#1}
  }

%
% \title{title}
% \thanks{text}
%
\renewcommand{\title}[1]{\def\articletitle{#1}\def\articlenote{}}
\renewcommand{\thanks}[1]{\def\articlenote{#1}}

\def\printtitle{
  \begin{flushleft}
    \lineskip 10pt
    {\LARGE \textbf{\articletitle}
     \ifthenelse{\equal{\articlenote}{}}{}{\footnote{\articlenote}}\\ }
  \end{flushleft}
  \vskip3mm}

%
% \author{authors}{university}
%
\renewcommand{\author}[2]{
  \def\articletitauthors{#1}
  \def\authorsuniversity{#2}}

\def\printauthors{
  \begin{flushleft}
    {\large\bf \articletitauthors} \\
    \smallskip
    {\small \authorsuniversity}
  \end{flushleft}
  \vskip3mm}

%
% \maketitle
%
\renewcommand{\maketitle}{
  \setupheaders
  \printfirstpagehead
%  \printlogo
  \printudc
  \printauthors
  \printtitle

  \addarticletoc{\noindent \MakeUppercase\articleauthors. \articletitle}}

%
% \articlehead[language]
%
%\newcommand{\articlehead}[1][rus]{
%   \ifthenelse{\equal{#1}{ukr}}{\ukrlang}{\rulang}
%   \setcounter{firstpage}{\value{page}}
%   \label{thefirstpage}
%   \maketitle}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Начало статьи.  Используйте необязательный параметр [eng] для статей на английском языке.
%
%\begin{article}[eng]

\newcommand{\articlehead}[1][eng]{%
   \ifthenelse{\equal{#1}{eng}}{\englang}{\ifthenelse{\equal{#1}{ukr}}{\ukrlang}{\rulang}}%
   \setcounter{firstpage}{\value{page}}
   \maketitle}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcounter{article}

\newenvironment{article}{%
  \def\@definecounter##1{\art@intdefinecounter{##1}%
    \@addtoreset{##1}{article}}%
  \renewcommand{\thearticle}{\roman{article}}%
  \refstepcounter{article}%
  \message{Article \number\c@article}%
  \gdef\@firstpage{\the\c@page}%
  \setlastpage
  \firstpage{1}
  \@addtoreset{section}{article}%
  \@addtoreset{table}{article}%
  \@addtoreset{figure}{article}%
  \@addtoreset{algorithm}{article}%
  \@addtoreset{definition}{article}%
  \@addtoreset{problem}{article}%
  \@addtoreset{proposition}{article}%
  \@addtoreset{theorem}{article}%
  \@addtoreset{lemma}{article}%
  \@addtoreset{corollary}{article}%
  \@addtoreset{proposal}{article}%
  \@addtoreset{remark}{article}%
  \@addtoreset{example}{article}%
  \@addtoreset{equation}{article}%
  \@addtoreset{footnote}{article}%
\articlehead}
  {\writelastpage
   \nopagebreak[4]
   \medskip
   \printdates}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Bottom matter
%

%
% \tocpagenumwidth
%
\def\tocpagenumwidth{0.75cm}

%
% \addarticletoc{text} % internal
% 
\newcommand{\addarticletoc}[1]{
  \addtocontents{toc} %toc
    {\protect
     \small\rm
     {\rightskip=3\parindent #1\par}
     \vskip-\baselineskip \hfill \thepage
     \par\medskip}}

%      \leaders\hbox to 1em{\hss.\hss}
%      \hfill \thepage}}}


%
% \date{date-of-receiving}
%
\def\dateofreceive{$\blacksquare\blacksquare.\blacksquare\blacksquare.\blacksquare\blacksquare\blacksquare\blacksquare$} % by default; replace using the following macro in preamble
\renewcommand{\date}[1]{\def\dateofreceive{#1}}

%
% \dateaccept{date-of-accepting}
%
\def\dateofaccept{$\blacksquare\blacksquare.\blacksquare\blacksquare.\blacksquare\blacksquare\blacksquare\blacksquare$} % by default
\newcommand{\dateaccept}[1]{\def\dateofaccept{#1}}


\newcommand{\oldcyr}{\def
\cyre
\CYRZH
\cyrzh
\CYRZ
\cyrz
\CYRI
\cyri
\CYRISHRT
\cyrishrt
\CYRK
\cyrk
\CYRL
\cyrl
\CYRM
\cyrm
\CYRN
\cyrn
\CYRO
\cyro
\CYRP
\cyrp
\CYRR
\cyrr
\CYRS
\cyrs
\CYRT
\cyrt
\CYRU
\cyru
\CYRF
\cyrf
\CYRH
\cyrh
\CYRC
\cyrc
\CYRCH
\cyrch
\CYRSH
\cyrsh
\CYRSHCH
\cyrshch
\CYRHRDSN
\cyrhrdsn
\CYRERY
\cyrery
\CYRSFTSN
\cyrsftsn
\CYREREV
\cyrerev
\CYRYU
\cyryu
\CYRYA
\cyrya   

\CYRGUP
\cyrgup
\CYRGHCRS
\cyrghcrs
%\CYRGDSC
%\cyrgdsc
%\CYRGHK
%\cyrghk
\CYRSHHA
\cyrshha
\CYRZHDSC
\cyrzhdsc
\CYRZDSC
\cyrzdsc
%\CYRABHDZE
%\cyrabhdze
\CYRYI
\cyryi
\CYRKDSC
\cyrkdsc
\CYRKBEAK
\cyrkbeak
%\CYRKHK
%\cyrkhk
%\CYRLHK
%\cyrlhk
\CYRNDSC
\cyrndsc
\CYRNG
\cyrng
%\CYRNHK
%\cyrnhk
\CYROTLD
\cyrotld
\CYRSDSC
\cyrsdsc
\CYRUSHRT
\cyrushrt
\CYRY
\cyry
\CYRYHCRS
\cyryhcrs
\CYRHDSC
\cyrhdsc
%\CYRHHK
%\cyrhhk
%\CYRCHLDSC
%\cyrchldsc
\CYRCHRDSC
\cyrchrdsc
\CYRIE
\cyrie
\CYRSCHWA
\cyrschwa
%\CYREPS
%\cyreps
\CYRYO
\cyryo
\CYRAE
\cyrae
\CYRDJE
\cyrdje
\CYRTSHE
\cyrtshe
%\CYRABHCH
%\cyrabhch
%\CYRABHCHDSC
%\cyrabhchdsc
\CYRKVCRS
\cyrkvcrs
%\CYRKHCRS
%\cyrkhcrs
%\CYRLDSC
%\cyrldsc
\CYRII
\cyrii
\CYRJE
\cyrje
\CYRLJE
\cyrlje
%\CYRMDSC
%\cyrmdsc
\CYRNJE
\cyrnje 
}

\def\printdates{\begin{flushleft}%
\textit{Received}:\space\dateofreceive%
\ifthenelse{\equal{\dateofaccept}{\dateofreceive}}%
{}%
{.\space\textit{Accepted:}\space\dateofaccept}%
\end{flushleft}}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Abstracts
%

\providecommand{\listofenabstracts}{\@starttoc{ena}}
%
% \enabstracts{MSC}{authors}{title}{content}
%
\newcommand{\enabstracts}[4]{
  \addtocontents{ena}
    {\protect\footnotesize
     \protect\bigskip
     \protect\par\noindent
     {\protect\selectlanguage{english}
%     MSC 2000: #1
      \protect\selectlanguage{russian}}
     \protect\nopagebreak[4]
     \protect\smallskip
     \protect\par\noindent
     {\protect\selectlanguage{english}
      \textsc{#2}.\space \textbf{#3} (\enlangname). %~//
       Researches in Mathematics, Dni\-pro:DNU, Vol.\jourvolume, No.~\journumber, \thepagerange(\jouryear).
      \protect\selectlanguage{russian}}
     \protect\medskip
     \protect\par
     {\protect\selectlanguage{english}
       \small{#4}
       \protect\selectlanguage{russian}}
     \protect\nopagebreak[4]
     \protect\medskip
     \protect\par\noindent
     {\protect\selectlanguage{english}
      \ifnum\value{figure}=0 %empty
      \else Fig.~\arabic{figure}. \fi
      \ifnum\value{table}=0 %empty
      \else Tbl.~\arabic{table}. \fi
      Ref.~\arabic{bibcounter}.
      % Fig.~N1. Tbl.~N2. Ref.~N.
      \protect\selectlanguage{russian}}}}

%% {\protect\selectlanguage{english}
%% \protect\selectlanguage{russian}}

\providecommand{\listofruabstracts}{\@starttoc{rua}}
%
% \ruabstracts{authors}{title}{content}
%
\newcommand{\ruabstracts}[3]{
  \addtocontents{rua}
    {\protect\footnotesize
     \protect\bigskip
     \protect\par\noindent \CYRU\CYRD\CYRK~\udcvalue
     \protect\nopagebreak[4]
     \protect\smallskip
     \protect\par\noindent {\sc #1}.\space {\bf #2} (\rulangname)~//
     Researches in Mathematics.~---
     \CYRD\CYRN\CYRU, \jouryear.~---\CYRV\cyrery\cyrp.~--- \CYRT\cyro\cyrm.~\jourvolume,\space
     \textnumero~\journumber.~--- 
     \CYRS.\thepagerange.
% Весник ДНУ. Серия: Математика.~--- ДНУ, 2009.~--- 
% Вып.~1.~--- С.~\pageref{thefirstpage}--\pageref{thelastpage}.}
     \protect\medskip
     \protect\par
     #3
     \protect\nopagebreak[4]
     \protect\medskip
     \protect\par\noindent
     \ifnum\value{figure}=0 %empty
     \else \CYRI\cyrl.~\arabic{figure}. \fi
     \ifnum\value{table}=0 %empty
     \else \CYRT\cyra\cyrb\cyrl.~\arabic{table}. \fi
     \CYRB\cyri\cyrb\cyrl\cyri\cyro\cyrg\cyrr.~\arabic{bibcounter}
     \cyrn\cyra\cyrz\cyrv.
% Ил.~N1. Табл.~N2. Библиогр.~N назв.
    }}
    
\providecommand{\listofuaabstracts}{\@starttoc{uaa}}
%
% \uaabstracts{authors}{title}{content}
%
\newcommand{\uaabstracts}[3]{
  \addtocontents{uaa}
    {\protect\footnotesize
     \protect\bigskip
     \protect\par\noindent \CYRU\CYRD\CYRK~\udcvalue
     \protect\nopagebreak[4]
     \protect\smallskip
     \protect\par\noindent {\sc #1}.\space {\bf #2} (\rulangname)~//
     Researches in Mathematics.~---
     \CYRD\CYRN\CYRU, \jouryear.~---\CYRV\cyri\cyrp\cyru\cyrs\cyrk.~--- \CYRT\cyro\cyrm.~\jourvolume,\space
     \textnumero~\journumber.~---
     \CYRS.\thepagerange.
% Вісник ДНУ. Серія: Математика.~--- ДНУ, 2009.~---
% Вип.~1.~--- С.~\pageref{thefirstpage}--\pageref{thelastpage}.}
     \protect\medskip
     \protect\par
     #3
     \protect\nopagebreak[4]
     \protect\medskip
     \protect\par\noindent
     \ifnum\value{figure}=0 %empty
     \else \CYRII\cyrl.~\arabic{figure}. \fi
     \ifnum\value{table}=0 %empty
     \else \CYRT\cyra\cyrb\cyrl.~\arabic{table}. \fi
     \CYRB\cyrii\cyrb\cyrl\cyrii\cyro\cyrg\cyrr.~\arabic{bibcounter}
     \cyrn\cyra\cyrz\cyrv.
% Іл.~N1. Табл.~N2. Бібліогр.~N назв.
    }}



%\def\annotmargin{1.0cm}

%
% Abstracts, keywords, MSC
%

\newcommand{\centeredsubpage}[2]{%
\par\noindent\hfill\begin{minipage}{0.8\textwidth}
{\footnotesize\textbf{#1} {#2}\par}
\end{minipage}\hfill{\ }\par}

\newcommand{\abstracten}[1]{\centeredsubpage{Abstract.}{#1}}
\newcommand{\abstractua}[1]{\centeredsubpage{Анотація.}{#1}}

\newcommand{\keywordsen}[1]{\centeredsubpage{Key words:}{#1}}
\newcommand{\keywordsua}[1]{\centeredsubpage{Ключові слова:}{#1}}

\def\mscyear{2020}
\newcommand{\mathsubjclass}[1]{\centeredsubpage{MSC\mscyear:}{\textsc{#1}}}


%\newcommand{\annot}[1]{
%  \begin{list}{}{\setlength{\leftmargin}{\annotmargin}
%                 \setlength{\rightmargin}{\annotmargin}}
%     \item[] #1
%  \end{list}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% The following is borrowed from kluwer.cls as of 2000/04/29.
% The marcos below are sligthly modified.
%
\newcommand{\vsecspace}[1]{%
   \if@nobreak\else
     \vskip #1\relax \fi}

\def\Shaveatleast{5\baselineskip}
\def\SShaveatleast{4\baselineskip}
\def\SSShaveatleast{4\baselineskip}
\newcommand{\@haveatleast}[1]{\relax\par \vskip #1
     \penalty 0\vskip -#1 \relax }

\newcommand{\Forcedhang}[1]{\leavevmode
    \setbox0=\hbox{#1}\hangindent\wd0
    \hangafter=1 \box0 }
\newcommand{\Shang}[1]{\Forcedhang{#1}}
\newcommand{\Sflushstyle}{\raggedright}
%\newcommand{\Snumstyle}{\normalfont\Large\bf}
%\newcommand{\Stextstyle}{\normalfont\Large\bf}
\newcommand{\Sspaceabove}{1\baselineskip plus6pt minus4pt}
\newcommand{\Sspaceafter}{\vskip 1\baselineskip plus3pt minus2pt}
%\newcommand{\Scase}[1]{#1}
\newcommand{\sectiondot}{.}

\newcommand{\@makesectionhead}[2]{\vsecspace{\Sspaceabove}%
  {\parindent0pt \spacebeforetheorem \hyphenpenalty=10000 \baselineskip12pt
   \Sflushstyle {\normalfont\large\bf #1}\par
   \nobreak \Sspaceafter \relax
   }}

\def\section{\@haveatleast{\Shaveatleast
    }\@afterindentfalse \secdef\@section\@ssection}

\def\@section[#1]#2{%
  \ifsinglenum \else \setcounter{equation}{0} \fi
  \ifnum \c@secnumdepth >\z@
    \refstepcounter{section}%
%    \addcontentsline{toc}{section}{\protect \numberline{\thesection}#1}%
  \else
%    \addcontentsline{toc}{section}{#1}%
  \fi
  \sectionmark{#1}%
  \@makesectionhead{\thesection\sectiondot~#2}%
  \@afterheading
  }

\def\@ssection#1{\@makesectionhead{#1}\@afterheading}

\newcommand{\SShang}[1]{\Forcedhang{#1}}
\newcommand{\SSflushstyle}{\raggedright}
%\newcommand{\SSnumstyle}{\normalsize\rm}
%\newcommand{\SStextstyle}{\sc}
\newcommand{\SSspaceabove}{1\baselineskip plus3pt minus2pt}
\newcommand{\SSspaceafter}{\vskip .8\baselineskip plus2pt minus2pt}
%\newcommand{\SScase}[1]{#1}
\newcommand{\@makesubsectionhead}[2]{\vsecspace{\SSspaceabove}%
  {\parindent0pt \hyphenpenalty=10000 \baselineskip12pt
   \SSflushstyle {\normalfont\normalsize\bf #1}\par
   \nobreak \SSspaceafter \relax
   }}

\def\subsection{\@haveatleast{\SShaveatleast}%
  \@afterindentfalse \secdef\@subsection\@ssubsection
  }

\def\@subsection[#1]#2{%
  \ifnum \c@secnumdepth >\@ne
    \refstepcounter{subsection}%
%    \addcontentsline{toc}{subsection}{\protect \numberline{\thesubsection}#1}%
  \else
%    \addcontentsline{toc}{subsection}{#1}%
  \fi
  \subsectionmark{#1}
  \@makesubsectionhead{\thesubsection\sectiondot~#2}%
  \@afterheading
  }
\def\@ssubsection#1{\@makesubsectionhead{#1}\@afterheading}
%
% end of kluwer.cls borrowings
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% A hack to get references title centered and avoid use of `markboth'.
%
\newcommand{\centersect}[1]{
  \bigskip
  \centerline{\large\bf #1}}

\newcommand\Nopagebreak{
  \makeatletter
  \@nobreaktrue\nopagebreak
  \makeatother}

\newcounter{bibcounter}
\renewenvironment{thebibliography}[1]
     {\centersect{\refname}
      \Nopagebreak %[4]
      \medskip
%%      \@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}%
      \list{\@biblabel{\@arabic\value{bibcounter}}} %\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{bibcounter} %enumiv}%
            %\let\p@enumiv\@empty
            \let\p@bibcounter\@empty
            %\renewcommand\theenumiv{\@arabic\c@enumiv}}%
            \renewcommand\thebibcounter{\@arabic\value{bibcounter}}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m
      \def\refitem##1##2{\bibitem{##1} {\it ##2}\/}}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}

\def\bibname{\normalsize\bf \myrefname}
\def\refname{\normalsize\bf \myrefname}
\def\@biblabel#1{#1.\hfill}
\newenvironment{references}
  {\def\refname{\normalsize\bf \myrefname}
   \small
   \begin{thebibliography}{99}
     \setlength{\itemsep}{-2.5pt}}
  {\end{thebibliography}}
%
% end of bibliography hack
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\endinput
